<?php
// projekTA/web/ganti_kartu.php
session_set_cookie_params([
  'lifetime'=>0,
  'path'=>'/',
  'httponly'=>true,
  'samesite'=>'Lax'
]);
session_start();
if (empty($_SESSION['user_id'])) {
  header('Location: login.php');
  exit;
}

require_once __DIR__ . '/../api/config.php';

// Ambil daftar santri aktif (sederhana; bisa diganti AJAX/pencarian)
$q = $mysqli->query("SELECT id, nama, rfid_uid, saldo FROM santri WHERE aktif=1 ORDER BY nama ASC");
$santri = [];
while ($row = $q->fetch_assoc()) $santri[] = $row;

?>
<!doctype html>
<html lang="id">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <title>Pergantian Kartu</title>
  <link rel="stylesheet" href="../assets/style.css">
  <style>
    .card{padding:18px}
    .muted{opacity:.7}
    .grid{display:grid;grid-template-columns:1fr 1fr;gap:16px}
    .danger{background:#fef2f2;color:#991b1b;padding:10px;border-radius:8px;margin-top:8px}
    .success{background:#f0fdf4;color:#14532d;padding:10px;border-radius:8px;margin-top:8px}
    label{display:block;margin:8px 0 4px}
    input[type=text], input[type=number], select{width:100%;padding:10px;border-radius:10px;border:1px solid #e5e7eb}
    button{padding:10px 14px;border-radius:10px;border:0;background:#2563eb;color:#fff;cursor:pointer}
    .btn.secondary{background:#10b981}
  </style>
</head>
<body>
  <div class="container">
    <div class="header">
      <h2 style="margin:0">Pergantian Kartu (Hilang/Rusak)</h2>
      <div><a href="index.php" class="btn secondary">← Kembali</a></div>
    </div>
    <div class="card">
      <form id="form-ganti">
        <div class="grid">
          <div>
            <label>Pilih Santri</label>
            <select name="id_santri" id="id_santri" required>
              <option value="">-- Pilih --</option>
              <?php foreach ($santri as $s): ?>
                <option value="<?= (int)$s['id'] ?>"
                        data-uid-lama="<?= htmlspecialchars($s['rfid_uid'] ?? '', ENT_QUOTES, 'UTF-8') ?>">
                  <?= htmlspecialchars($s['nama'], ENT_QUOTES, 'UTF-8') ?> (Saldo: Rp<?= number_format((int)$s['saldo'],0,',','.') ?>)
                </option>
              <?php endforeach; ?>
            </select>

            <label>UID Lama</label>
            <input type="text" id="uid_lama" value="" readonly class="muted">

            <label>UID Baru</label>
            <input type="text" id="uid_baru" name="uid_baru" placeholder="Tempelkan kartu baru..." required>

            <div id="uid_info" class="muted"></div>
          </div>
          <div>
            <label>Alasan</label>
            <select name="alasan" id="alasan">
              <option value="hilang">Hilang</option>
              <option value="rusak">Rusak</option>
              <option value="lainnya">Lainnya</option>
            </select>

            <label>Biaya (opsional)</label>
            <input type="number" name="biaya" id="biaya" min="0" value="0">

            <label>Catatan</label>
            <input type="text" name="catatan" id="catatan" placeholder="Misal: Kartu jatuh di asrama">

            <div class="notice">
              <b>Tips:</b> Tempel kartu baru ke reader. Kolom <i>UID Baru</i> akan terisi otomatis bila perangkat meng-update UID terakhir.
            </div>
          </div>
        </div>
        <div style="margin-top:16px">
          <button id="btnSubmit" type="submit">Simpan Pergantian</button>
        </div>
      </form>

      <div id="msg" style="margin-top:12px"></div>
    </div>
  </div>

<script>
const selectSantri = document.getElementById('id_santri');
const inpUidLama   = document.getElementById('uid_lama');
const inpUidBaru   = document.getElementById('uid_baru');
const infoUid      = document.getElementById('uid_info');
const btnSubmit    = document.getElementById('btnSubmit');
const msg          = document.getElementById('msg');

// Tampilkan UID lama saat santri dipilih
selectSantri.addEventListener('change', () => {
  const opt = selectSantri.options[selectSantri.selectedIndex];
  inpUidLama.value = opt ? (opt.getAttribute('data-uid-lama') || '') : '';
});

// Polling UID terbaru (via web/get_uid.php yang sudah ada)
let last = null;
setInterval(async () => {
  try {
    const res = await fetch('get_uid.php', { cache: 'no-store' });
    const js  = await res.json();
    if (js && js.uid && js.uid !== last) {
      last = js.uid;
      inpUidBaru.value = js.uid.toUpperCase();

      // Beri info apakah UID sudah terdaftar
      if (js.registered) {
        infoUid.innerHTML = '<div class="danger">UID tersebut sudah terdaftar untuk <b>'+ (js.santri?.nama || 'santri lain') +'</b>. Gunakan kartu lain.</div>';
        btnSubmit.disabled = true;
      } else {
        infoUid.innerHTML = '<div class="success">UID tersedia. Bisa dipakai.</div>';
        btnSubmit.disabled = false;
      }
    }
  } catch (e) {
    // abaikan error polling
  }
}, 800);

// Submit
document.getElementById('form-ganti').addEventListener('submit', async (ev) => {
  ev.preventDefault();
  msg.innerHTML = '';

  const id_santri = selectSantri.value;
  const uid_baru  = inpUidBaru.value.trim().toUpperCase();
  const alasan    = document.getElementById('alasan').value;
  const biaya     = document.getElementById('biaya').value;
  const catatan   = document.getElementById('catatan').value;

  if (!id_santri || !uid_baru) {
    msg.innerHTML = '<div class="danger">Lengkapi data terlebih dahulu.</div>';
    return;
  }

  btnSubmit.disabled = true;
  try {
    const form = new FormData();
    form.append('id_santri', id_santri);
    form.append('uid_baru', uid_baru);
    form.append('alasan', alasan);
    form.append('biaya', biaya);
    form.append('catatan', catatan);

    const res = await fetch('../api/replace_card.php', { method: 'POST', body: form });
    const js  = await res.json();

    if (js.status === 'ok') {
      msg.innerHTML = '<div class="success">Kartu berhasil diganti untuk <b>'+ js.data.nama +'</b>. UID lama: '+ (js.data.uid_lama || '-') +', UID baru: '+ js.data.uid_baru +'.</div>';
      // kosongkan kolom UID baru
      inpUidBaru.value = '';
      infoUid.innerHTML = '';
    } else {
      msg.innerHTML = '<div class="danger">'+ (js.message || 'Gagal menyimpan') +'</div>';
    }
  } catch (e) {
    msg.innerHTML = '<div class="danger">Terjadi kesalahan jaringan.</div>';
  } finally {
    btnSubmit.disabled = false;
  }
});
</script>
</body>
</html>